/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ClashEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CaptivatingGlanceEffect
extends OneShotEffect {
    CaptivatingGlanceEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "clash with an opponent. If you win, gain control of enchanted creature. Otherwise, that player gains control of enchanted creature";
    }

    private CaptivatingGlanceEffect(CaptivatingGlanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public CaptivatingGlanceEffect copy() {
        return new CaptivatingGlanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent captivatingGlance = game.getPermanent(source.getSourceId());
        if (controller != null && captivatingGlance != null) {
            Permanent enchantedCreature = game.getPermanent(captivatingGlance.getAttachedTo());
            boolean clashResult = new ClashEffect().apply(game, source);
            if (enchantedCreature != null) {
                if (clashResult) {
                    GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, controller.getId());
                    effect.setTargetPointer((TargetPointer)new FixedTarget(enchantedCreature, game));
                    game.addEffect((ContinuousEffect)effect, source);
                } else {
                    Player opponent = game.getPlayer((UUID)this.getValue("clashOpponent"));
                    if (opponent != null) {
                        GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, opponent.getId());
                        effect.setTargetPointer((TargetPointer)new FixedTarget(enchantedCreature, game));
                        game.addEffect((ContinuousEffect)effect, source);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

