/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;

class CapturedByTheConsulateEffect
extends OneShotEffect {
    CapturedByTheConsulateEffect() {
        super(Outcome.Benefit);
        this.staticText = "change the target to enchanted creature if able";
    }

    private CapturedByTheConsulateEffect(CapturedByTheConsulateEffect effect) {
        super((OneShotEffect)effect);
    }

    public CapturedByTheConsulateEffect copy() {
        return new CapturedByTheConsulateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceEnchantment = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourceEnchantment != null) {
            Target target;
            StackObject stackObject = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
            if (stackObject != null && (target = (Target)stackObject.getStackAbility().getTargets().get(0)) != null && target.canTarget(stackObject.getControllerId(), sourceEnchantment.getAttachedTo(), source, game)) {
                target.remove(target.getFirstTarget());
                target.add(sourceEnchantment.getAttachedTo(), game);
            }
            return true;
        }
        return false;
    }
}

