/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;

class CaromEffect
extends RedirectionEffect {
    protected MageObjectReference redirectToObject;

    public CaromEffect(Duration duration, int amount) {
        super(duration, amount, RedirectionEffect.UsageType.ONE_USAGE_ABSOLUTE);
        this.staticText = "The next " + amount + " damage that would be dealt to target creature this turn is dealt to another target creature instead";
    }

    private CaromEffect(CaromEffect effect) {
        super((RedirectionEffect)effect);
    }

    public CaromEffect copy() {
        return new CaromEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.redirectToObject = new MageObjectReference(((Target)source.getTargets().get(1)).getFirstTarget(), game);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(this.getTargetPointer().getFirst(game, source)) && game.getControllerId(this.redirectToObject.getSourceId()) != null && this.redirectToObject.equals((Object)new MageObjectReference(((Target)source.getTargets().get(1)).getFirstTarget(), game))) {
            this.redirectTarget = (Target)source.getTargets().get(1);
            return true;
        }
        return false;
    }
}

