/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class CarrionCruiserEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("creature or Vehicle card");

    CarrionCruiserEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then return a creature or Vehicle card from your graveyard to your hand";
    }

    private CarrionCruiserEffect(CarrionCruiserEffect effect) {
        super((OneShotEffect)effect);
    }

    public CarrionCruiserEffect copy() {
        return new CarrionCruiserEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().count(filter, game) < 1) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.HAND, source, game);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
    }
}

