/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CarryAwayEffect
extends OneShotEffect {
    CarryAwayEffect() {
        super(Outcome.Detriment);
        this.staticText = "unattach enchanted Equipment.";
    }

    private CarryAwayEffect(CarryAwayEffect effect) {
        super((OneShotEffect)effect);
    }

    public CarryAwayEffect copy() {
        return new CarryAwayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent equippedCreature;
        Permanent enchantedEquipment;
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && (enchantedEquipment = game.getPermanent(permanent.getAttachedTo())) != null && (equippedCreature = game.getPermanent(enchantedEquipment.getAttachedTo())) != null) {
            return equippedCreature.removeAttachment(enchantedEquipment.getId(), source, game);
        }
        return false;
    }
}

