/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.constants.PutCards;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPlaneswalkerCard;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class CarthTheLionTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPlaneswalkerCard filter = new FilterPlaneswalkerCard("a planeswalker card");

    public CarthTheLionTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LookLibraryAndPickControllerEffect(7, 1, (FilterCard)filter, PutCards.HAND, PutCards.BOTTOM_RANDOM));
        this.setTriggerPhrase("Whenever {this} enters or a planeswalker you control dies, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private CarthTheLionTriggeredAbility(CarthTheLionTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CarthTheLionTriggeredAbility copy() {
        return new CarthTheLionTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && event.getTargetId().equals(this.getSourceId())) {
            return true;
        }
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && event.getPlayerId().equals(this.getControllerId()) && (zEvent = (ZoneChangeEvent)event).isDiesEvent()) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(zEvent.getTargetId());
            return permanent != null && permanent.isPlaneswalker(game);
        }
        return false;
    }
}

