/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.c.CartographersHawkEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;

class CartographersHawkTriggeredAbility
extends TriggeredAbilityImpl {
    CartographersHawkTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CartographersHawkEffect(), false);
    }

    private CartographersHawkTriggeredAbility(CartographersHawkTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CartographersHawkTriggeredAbility copy() {
        return new CartographersHawkTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getSourceId().equals(this.getSourceId()) && game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_LAND, this.getControllerId(), game) < game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_LAND, event.getTargetId(), game);
    }

    public String getRule() {
        return "When {this} deals combat damage to a player who controls more lands than you, return it to its owner's hand. If you do, you may search your library for a Plains card, put it onto the battlefield tapped, then shuffle.";
    }
}

