/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class CaseOfTheBurningMasksWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> damagingObjects = new HashMap<UUID, Set<MageObjectReference>>();

    CaseOfTheBurningMasksWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGED_PERMANENT: 
            case DAMAGED_PLAYER: {
                this.damagingObjects.computeIfAbsent(game.getControllerId(event.getSourceId()), k -> new HashSet()).add(new MageObjectReference(event.getSourceId(), game));
            }
        }
    }

    public void reset() {
        super.reset();
        this.damagingObjects.clear();
    }

    public int damagingCountByController(UUID controllerId) {
        return this.damagingObjects.getOrDefault(controllerId, Collections.emptySet()).size();
    }
}

