/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Objects;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.MayCastFromGraveyardSourceAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class CaseOfTheUneatenFeastEffect
extends ContinuousEffectImpl {
    CaseOfTheUneatenFeastEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Creature cards in your graveyard gain \"You may cast this card from your graveyard\" until end of turn";
    }

    private CaseOfTheUneatenFeastEffect(CaseOfTheUneatenFeastEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public CaseOfTheUneatenFeastEffect copy() {
        return new CaseOfTheUneatenFeastEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        if (!this.getAffectedObjectsSet()) {
            return;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return;
        }
        player.getGraveyard().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).filter(card -> card.isCreature(game)).forEach(card -> this.affectedObjectList.add(new MageObjectReference((MageObject)card, game)));
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.getGraveyard().stream().filter(cardId -> this.affectedObjectList.contains(new MageObjectReference(cardId, game))).forEach(cardId -> {
            Card card = game.getCard(cardId);
            if (card == null) {
                return;
            }
            MayCastFromGraveyardSourceAbility ability = new MayCastFromGraveyardSourceAbility();
            ability.setSourceId(cardId);
            ability.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, (Ability)ability);
        });
        return true;
    }
}

