/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaPaidEvent;
import mage.game.events.ZoneChangeEvent;
import mage.util.Copyable;
import mage.watchers.Watcher;

class CataclysmicProspectingWatcher
extends Watcher {
    private static final DesertManaPaidTracker emptyTracker = new DesertManaPaidTracker();
    private final Map<UUID, DesertManaPaidTracker> manaMap = new HashMap<UUID, DesertManaPaidTracker>();

    public CataclysmicProspectingWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case ZONE_CHANGE: {
                if (((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD || ((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD) {
                    this.manaMap.remove(event.getTargetId());
                }
                return;
            }
            case MANA_PAID: {
                ManaPaidEvent manaEvent = (ManaPaidEvent)event;
                this.manaMap.computeIfAbsent(manaEvent.getTargetId(), x -> new DesertManaPaidTracker()).increment(manaEvent.getSourceObject(), game);
                this.manaMap.computeIfAbsent(manaEvent.getSourcePaidId(), x -> new DesertManaPaidTracker()).increment(manaEvent.getSourceObject(), game);
            }
        }
    }

    public void reset() {
        super.reset();
        this.manaMap.clear();
    }

    public static int getDesertsAmount(UUID sourceId, Game game) {
        CataclysmicProspectingWatcher watcher = (CataclysmicProspectingWatcher)game.getState().getWatcher(CataclysmicProspectingWatcher.class);
        return watcher == null ? 0 : watcher.manaMap.getOrDefault(sourceId, emptyTracker).desertMana;
    }

    private static final class DesertManaPaidTracker
    implements Serializable,
    Copyable<DesertManaPaidTracker> {
        private int desertMana = 0;

        private DesertManaPaidTracker() {
        }

        private DesertManaPaidTracker(DesertManaPaidTracker tracker) {
            this.desertMana = tracker.desertMana;
        }

        public DesertManaPaidTracker copy() {
            return new DesertManaPaidTracker(this);
        }

        private void increment(MageObject sourceObject, Game game) {
            if (sourceObject != null && sourceObject.hasSubtype(SubType.DESERT, game)) {
                ++this.desertMana;
            }
        }
    }
}

