/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CatastropheEffect
extends OneShotEffect {
    CatastropheEffect() {
        super(Outcome.Detriment);
        this.staticText = "Destroy all lands or all creatures. Creatures destroyed this way can't be regenerated";
    }

    private CatastropheEffect(CatastropheEffect effect) {
        super((OneShotEffect)effect);
    }

    public CatastropheEffect copy() {
        return new CatastropheEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (controller.chooseUse(this.outcome, "Destroy all lands? (otherwise all creatures are destroyed)", source, game)) {
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterLandPermanent(), controller.getId(), source, game)) {
                    permanent.destroy(source, game, permanent.isCreature(game));
                }
            } else {
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), source, game)) {
                    permanent.destroy(source, game, true);
                }
            }
            return true;
        }
        return false;
    }
}

