/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.BlockedAttackerWatcher;

class CathedralMembraneEffect
extends OneShotEffect {
    CathedralMembraneEffect() {
        super(Outcome.Damage);
        this.staticText = "it deals 6 damage to each creature it blocked this combat";
    }

    private CathedralMembraneEffect(CathedralMembraneEffect effect) {
        super((OneShotEffect)effect);
    }

    public CathedralMembraneEffect copy() {
        return new CathedralMembraneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        BlockedAttackerWatcher watcher = (BlockedAttackerWatcher)game.getState().getWatcher(BlockedAttackerWatcher.class);
        if (watcher != null && permanent != null) {
            for (Permanent p : watcher.getBlockedCreatures(new MageObjectReference((MageObject)permanent, game), game)) {
                p.damage(6, source.getSourceId(), source, game, false, true);
            }
        }
        return true;
    }
}

