/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.DiesSourceTriggeredAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.abilities.keyword.LifelinkAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetOpponentsCreaturePermanent;

public final class CavalierOfNight
extends CardImpl {
    private static final FilterCard filter = new FilterCreatureCard("creature card with mana value 3 or less from your graveyard");

    public CavalierOfNight(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{B}{B}{B}");
        this.subtype.add((Object)SubType.ELEMENTAL);
        this.subtype.add((Object)SubType.KNIGHT);
        this.power = new MageInt(4);
        this.toughness = new MageInt(5);
        this.addAbility((Ability)LifelinkAbility.getInstance());
        ReflexiveTriggeredAbility triggeredAbility = new ReflexiveTriggeredAbility((Effect)new DestroyTargetEffect(), false, "destroy target creature an opponent controls");
        triggeredAbility.addTarget((Target)new TargetOpponentsCreaturePermanent());
        this.addAbility((Ability)new EntersBattlefieldTriggeredAbility((Effect)new DoWhenCostPaid(triggeredAbility, (Cost)new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE), "Sacrifice a creature?")));
        DiesSourceTriggeredAbility ability = new DiesSourceTriggeredAbility((Effect)new ReturnFromGraveyardToBattlefieldTargetEffect());
        ability.addTarget((Target)new TargetCardInYourGraveyard(filter));
        this.addAbility((Ability)ability);
    }

    private CavalierOfNight(CavalierOfNight card) {
        super((CardImpl)card);
    }

    public CavalierOfNight copy() {
        return new CavalierOfNight(this);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 4));
    }
}

