/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;

enum CavernHoardDragonCount implements DynamicValue
{
    instance;

    private static final Hint hint;

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return CavernHoardDragonCount.getValue(sourceAbility.getControllerId(), sourceAbility, game);
    }

    public static int getValue(UUID playerId, Ability source, Game game) {
        int max = 0;
        for (UUID opponentId : game.getOpponents(playerId)) {
            Player player = game.getPlayer(opponentId);
            if (player == null) continue;
            FilterArtifactPermanent filter = new FilterArtifactPermanent();
            filter.add((Predicate)new ControllerIdPredicate(opponentId));
            int count = game.getBattlefield().count((FilterPermanent)filter, playerId, source, game);
            max = Math.max(count, max);
        }
        return max;
    }

    public CavernHoardDragonCount copy() {
        return this;
    }

    public String toString() {
        return "X";
    }

    public String getMessage() {
        return "the greatest number of artifacts an opponent controls";
    }

    public static Hint getHint() {
        return hint;
    }

    static {
        hint = new ValueHint("Greatest number of artifacts an opponent controls", (DynamicValue)instance);
    }
}

