/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;
import mage.watchers.common.CompletedDungeonWatcher;

class CavesOfChaosAdventurerEffect
extends OneShotEffect {
    CavesOfChaosAdventurerEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. If you've completed a dungeon, you may play that card this turn without paying its mana cost. Otherwise, you may play that card this turn";
    }

    private CavesOfChaosAdventurerEffect(CavesOfChaosAdventurerEffect effect) {
        super((OneShotEffect)effect);
    }

    public CavesOfChaosAdventurerEffect copy() {
        return new CavesOfChaosAdventurerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        if (CompletedDungeonWatcher.checkPlayer((UUID)source.getControllerId(), (Game)game)) {
            game.addEffect(new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, TargetController.YOU, Duration.EndOfTurn, true).setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        } else {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false);
        }
        return true;
    }
}

