/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CemeteryDesecratorRemoveCountersEffect
extends OneShotEffect {
    private final int xValue;

    public CemeteryDesecratorRemoveCountersEffect(int xValue) {
        super(Outcome.UnboostCreature);
        this.xValue = xValue;
        this.staticText = "Remove X counters from target permanent, where X is the mana value of the exiled card";
    }

    private CemeteryDesecratorRemoveCountersEffect(CemeteryDesecratorRemoveCountersEffect effect) {
        super((OneShotEffect)effect);
        this.xValue = effect.xValue;
    }

    public CemeteryDesecratorRemoveCountersEffect copy() {
        return new CemeteryDesecratorRemoveCountersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (controller == null || permanent == null) {
            return false;
        }
        if (this.xValue < 1) {
            return false;
        }
        Counters counters = permanent.getCounters(game).copy();
        int totalCounters = 0;
        for (Counter counter : counters.values()) {
            totalCounters += counter.getCount();
        }
        if (totalCounters == 0) {
            return false;
        }
        if (totalCounters <= this.xValue) {
            for (Map.Entry entry : counters.entrySet()) {
                permanent.removeCounters((String)entry.getKey(), ((Counter)entry.getValue()).getCount(), source, game);
            }
            return true;
        }
        if (counters.size() == 1) {
            String counterName = (String)counters.keySet().iterator().next();
            permanent.removeCounters(counterName, this.xValue, source, game);
            return true;
        }
        int remainingCounters = totalCounters;
        int countersLeftToRemove = this.xValue;
        for (Map.Entry entry : counters.entrySet()) {
            String counterName = (String)entry.getKey();
            int numCounters = ((Counter)entry.getValue()).getCount();
            int min = Math.max(0, countersLeftToRemove - (remainingCounters -= numCounters));
            int max = Math.min(countersLeftToRemove, numCounters);
            int toRemove = controller.getAmount(min, max, counterName + " counters to remove", source, game);
            toRemove = Math.max(toRemove, min);
            toRemove = Math.min(toRemove, max);
            permanent.removeCounters(counterName, toRemove, source, game);
            if ((countersLeftToRemove -= toRemove) > 0) continue;
            break;
        }
        return true;
    }
}

