/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;
import mage.watchers.common.OnceEachTurnCastWatcher;

class CemeteryIlluminatorPlayTopEffect
extends AsThoughEffectImpl {
    CemeteryIlluminatorPlayTopEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Once each turn, you may cast a spell from the top of your library if it shares a card type with a card exiled with {this}";
    }

    private CemeteryIlluminatorPlayTopEffect(CemeteryIlluminatorPlayTopEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public CemeteryIlluminatorPlayTopEffect copy() {
        return new CemeteryIlluminatorPlayTopEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        throw new IllegalArgumentException("Wrong code usage: can't call applies method on empty affectedAbility");
    }

    public boolean applies(UUID objectId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        Player controller = game.getPlayer(source.getControllerId());
        OnceEachTurnCastWatcher watcher = (OnceEachTurnCastWatcher)game.getState().getWatcher(OnceEachTurnCastWatcher.class);
        Permanent sourceObject = source.getSourcePermanentIfItStillExists(game);
        if (controller == null || watcher == null || sourceObject == null) {
            return false;
        }
        if (!playerId.equals(controller.getId()) || watcher.isAbilityUsed(playerId, new MageObjectReference((MageObject)sourceObject, game))) {
            return false;
        }
        Card card = game.getCard(objectId);
        Card topCard = controller.getLibrary().getFromTop(game);
        if (card == null || topCard == null || !topCard.getId().equals(card.getMainCard().getId())) {
            return false;
        }
        if (!(affectedAbility instanceof SpellAbility)) {
            return false;
        }
        Card cardToCast = ((SpellAbility)affectedAbility).getCharacteristics(game);
        if (cardToCast.getManaCost().isEmpty()) {
            return false;
        }
        HashSet cardTypes = new HashSet(cardToCast.getCardType(game));
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)game.getState().getZoneChangeCounter(source.getSourceId()));
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        if (exileZone == null) {
            return false;
        }
        return exileZone.stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).flatMap(c -> c.getCardType(game).stream()).anyMatch(cardTypes::contains);
    }
}

