/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.TargetPermanent;

class CephalidConstableTriggeredAbility
extends TriggeredAbilityImpl {
    CephalidConstableTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ReturnToHandTargetEffect(), false);
    }

    private CephalidConstableTriggeredAbility(CephalidConstableTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CephalidConstableTriggeredAbility copy() {
        return new CephalidConstableTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getSourceId().equals(this.sourceId) && ((DamagedPlayerEvent)event).isCombatDamage()) {
            FilterPermanent filter = new FilterPermanent("permanent" + (event.getAmount() > 1 ? "s" : "") + " damaged player control");
            filter.add((Predicate)new ControllerIdPredicate(event.getPlayerId()));
            TargetPermanent target = new TargetPermanent(0, event.getAmount(), filter, false);
            this.getTargets().clear();
            this.getTargets().add((Target)target);
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} deals combat damage to a player, return up to that many target permanents that player controls to their owner's hand.";
    }
}

