/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBeBlockedSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;

class CephalidFacetakerEffect
extends OneShotEffect {
    private static final CopyApplier copyApplier = new CopyApplier(){

        public boolean apply(Game game, MageObject blueprint, Ability source, UUID targetObjectId) {
            blueprint.getPower().setModifiedBaseValue(1);
            blueprint.getToughness().setModifiedBaseValue(4);
            blueprint.getAbilities().add((Object)new SimpleStaticAbility((Effect)new CantBeBlockedSourceEffect().setText("this creature can't be blocked")));
            return true;
        }
    };

    CephalidFacetakerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may have {this} become a copy of another target creature until end of turn, except it's 1/4 and has \"This creature can't be blocked.\"";
    }

    private CephalidFacetakerEffect(CephalidFacetakerEffect effect) {
        super((OneShotEffect)effect);
    }

    public CephalidFacetakerEffect copy() {
        return new CephalidFacetakerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent == null || creature == null) {
            return false;
        }
        game.copyPermanent(Duration.EndOfTurn, creature, sourcePermanent.getId(), source, copyApplier);
        return true;
    }
}

