/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CephalidVandalEffect
extends OneShotEffect {
    CephalidVandalEffect() {
        super(Outcome.Neutral);
        this.staticText = "Then mill a card for each shred counter on {this}";
    }

    private CephalidVandalEffect(CephalidVandalEffect effect) {
        super((OneShotEffect)effect);
    }

    public CephalidVandalEffect copy() {
        return new CephalidVandalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && controller != null) {
            int amount = permanent.getCounters(game).getCount(CounterType.SHRED);
            controller.millCards(amount, source, game);
        }
        return true;
    }
}

