/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class CerebralVortexWatcher
extends Watcher {
    private final Map<UUID, Integer> draws = new HashMap<UUID, Integer>();

    CerebralVortexWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DREW_CARD) {
            int count = 1;
            if (this.draws.containsKey(event.getPlayerId())) {
                count += this.draws.get(event.getPlayerId()).intValue();
            }
            this.draws.put(event.getPlayerId(), count);
        }
    }

    public void reset() {
        super.reset();
        this.draws.clear();
    }

    public int getDraws(UUID playerId) {
        return this.draws.getOrDefault(playerId, 0);
    }
}

