/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.condition.common.MorbidCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChainAssassinationEffect
extends OneShotEffect {
    ChainAssassinationEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy target creature. If another creature died this turn, draw a card";
    }

    private ChainAssassinationEffect(ChainAssassinationEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChainAssassinationEffect copy() {
        return new ChainAssassinationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean flag = MorbidCondition.instance.apply(game, source);
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        permanent.destroy(source, game);
        if (!flag) {
            return true;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.drawCards(1, source, game);
        }
        return true;
    }
}

