/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChainOfAcidEffect
extends OneShotEffect {
    ChainOfAcidEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target noncreature permanent. Then that permanent's controller may copy this spell and may choose a new target for that copy.";
    }

    private ChainOfAcidEffect(ChainOfAcidEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChainOfAcidEffect copy() {
        return new ChainOfAcidEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player affectedPlayer;
        UUID targetId;
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (permanent = game.getPermanent(targetId = source.getFirstTarget())) != null && (affectedPlayer = game.getPlayer(permanent.getControllerId())) != null) {
            Spell spell;
            DestroyTargetEffect effect = new DestroyTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetId, game));
            effect.apply(game, source);
            if (affectedPlayer.chooseUse(Outcome.Copy, "Copy the spell?", source, game) && (spell = game.getStack().getSpell(source.getSourceId())) != null) {
                spell.createCopyOnStack(game, source, affectedPlayer.getId(), true);
            }
            return true;
        }
        return false;
    }
}

