/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChainOfSmogEffect
extends OneShotEffect {
    ChainOfSmogEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player discards two cards. That player may copy this spell and may choose a new target for that copy.";
    }

    private ChainOfSmogEffect(ChainOfSmogEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChainOfSmogEffect copy() {
        return new ChainOfSmogEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetId;
        Player affectedPlayer;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (affectedPlayer = game.getPlayer(targetId = source.getFirstTarget())) != null) {
            Spell spell;
            DiscardTargetEffect effect = new DiscardTargetEffect(2);
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetId, game));
            effect.apply(game, source);
            if (affectedPlayer.chooseUse(Outcome.Copy, "Copy the spell?", source, game) && (spell = game.getStack().getSpell(source.getSourceId())) != null) {
                spell.createCopyOnStack(game, source, affectedPlayer.getId(), true);
                game.informPlayers(affectedPlayer.getLogName() + " copies " + spell.getName() + '.');
            }
            return true;
        }
        return false;
    }
}

