/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ChainersTormentNightmareToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class ChainersTormentEffect
extends OneShotEffect {
    ChainersTormentEffect() {
        super(Outcome.Benefit);
        this.staticText = "Create an X/X black Nightmare Horror creature token, where X is half your life total, rounded up. It deals X damage to you";
    }

    private ChainersTormentEffect(ChainersTormentEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChainersTormentEffect copy() {
        return new ChainersTormentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = (int)Math.ceil(1.0 * (double)Math.max(0, player.getLife()) / 2.0);
        CreateTokenEffect effect = new CreateTokenEffect((Token)new ChainersTormentNightmareToken(xValue));
        if (effect.apply(game, source)) {
            for (UUID tokenId : effect.getLastAddedTokenIds()) {
                Permanent token = game.getPermanentOrLKIBattlefield(tokenId);
                if (token == null) continue;
                player.damage(xValue, tokenId, source, game);
            }
        }
        return true;
    }
}

