/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ChainflailCentipedeTriggeredAbility
extends TriggeredAbilityImpl {
    ChainflailCentipedeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostTargetEffect(2, 0));
    }

    private ChainflailCentipedeTriggeredAbility(ChainflailCentipedeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ChainflailCentipedeTriggeredAbility copy() {
        return new ChainflailCentipedeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        UUID attacker = !game.getCombat().getAttackers().contains(this.getSourceId()) ? ((permanent = this.getSourcePermanentOrLKI(game)) != null && game.getCombat().getAttackers().contains(permanent.getAttachedTo()) ? permanent.getAttachedTo() : null) : this.getSourceId();
        if (attacker == null) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(attacker, game));
        return true;
    }

    public String getRule() {
        return "Whenever {this} or equipped creature attacks, it gets +2/+0 until end of turn.";
    }
}

