/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.CardsDrawnDuringDrawStepWatcher;

class ChainsOfMephistophelesReplacementEffect
extends ReplacementEffectImpl {
    ChainsOfMephistophelesReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a player would draw a card except the first one they draw in each of their draw steps, that player discards a card instead. If the player discards a card this way, they draw a card. If the player doesn't discard a card this way, they mill a card";
    }

    private ChainsOfMephistophelesReplacementEffect(ChainsOfMephistophelesReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ChainsOfMephistophelesReplacementEffect copy() {
        return new ChainsOfMephistophelesReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        if (player != null) {
            if (player.getHand().isEmpty()) {
                MillCardsTargetEffect effect = new MillCardsTargetEffect(1);
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
                effect.apply(game, source);
                return true;
            }
            player.discard(1, false, false, source, game);
            return false;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (game.isActivePlayer(event.getPlayerId()) && game.getPhase().getStep().getType() == PhaseStep.DRAW) {
            CardsDrawnDuringDrawStepWatcher watcher = (CardsDrawnDuringDrawStepWatcher)game.getState().getWatcher(CardsDrawnDuringDrawStepWatcher.class);
            return watcher != null && watcher.getAmountCardsDrawn(event.getPlayerId()) > 0;
        }
        return true;
    }
}

