/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ChallengerTrollEffect
extends ContinuousEffectImpl {
    ChallengerTrollEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Each creature you control with power 4 or greater can't be blocked by more than one creature.";
    }

    private ChallengerTrollEffect(ChallengerTrollEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ChallengerTrollEffect copy() {
        return new ChallengerTrollEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        if (layer != Layer.RulesEffects) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (permanent == null || !permanent.isControlledBy(source.getControllerId()) || !permanent.isCreature(game) || permanent.getPower().getValue() < 4) continue;
            permanent.setMaxBlockedBy(1);
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

