/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ChandraAblazeCastCardsEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterInstantOrSorceryCard();

    public ChandraAblazeCastCardsEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Cast any number of red instant and/or sorcery cards from your graveyard without paying their mana costs";
    }

    private ChandraAblazeCastCardsEffect(ChandraAblazeCastCardsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandraAblazeCastCardsEffect copy() {
        return new ChandraAblazeCastCardsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardUtil.castMultipleWithAttributeForFree((Player)player, (Ability)source, (Game)game, (Cards)new CardsImpl(player.getGraveyard().getCards(filter, game)), (FilterCard)StaticFilters.FILTER_CARD);
        return true;
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.RED));
    }
}

