/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ChandraDrawEffect
extends OneShotEffect {
    ChandraDrawEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Discard all the cards in your hand, then draw that many cards plus one";
    }

    private ChandraDrawEffect(ChandraDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChandraDrawEffect copy() {
        return new ChandraDrawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int amount = player.discard(player.getHand(), false, source, game).size();
        player.drawCards(amount + 1, source, game);
        return true;
    }
}

