/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetOpponentOrPlaneswalker;

class ChandraFireArtisanTriggeredAbility
extends TriggeredAbilityImpl {
    ChandraFireArtisanTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
        this.addTarget((Target)new TargetOpponentOrPlaneswalker());
    }

    private ChandraFireArtisanTriggeredAbility(ChandraFireArtisanTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_REMOVED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getAmount() == 0 || !event.getData().equals(CounterType.LOYALTY.getName()) || !event.getTargetId().equals(this.getSourceId())) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new DamageTargetEffect(event.getAmount()));
        return true;
    }

    public ChandraFireArtisanTriggeredAbility copy() {
        return new ChandraFireArtisanTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more loyalty counters are removed from {this}, she deals that much damage to target opponent or planeswalker.";
    }
}

