/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Cards;
import mage.cards.c.ChandraHopesBeaconWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class ChandraHopesBeaconPlayEffect
extends AsThoughEffectImpl {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    ChandraHopesBeaconPlayEffect(Cards cards, Game game) {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.UntilEndOfYourNextTurn, Outcome.Benefit);
        cards.stream().map(uuid -> new MageObjectReference(uuid, game)).forEach(this.morSet::add);
    }

    private ChandraHopesBeaconPlayEffect(ChandraHopesBeaconPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.morSet.addAll(effect.morSet);
    }

    public ChandraHopesBeaconPlayEffect copy() {
        return new ChandraHopesBeaconPlayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        UUID objectIdToCast = CardUtil.getMainCardId((Game)game, (UUID)sourceId);
        return source.isControlledBy(affectedControllerId) && this.morSet.stream().anyMatch(mor -> mor.refersTo(objectIdToCast, game)) && ChandraHopesBeaconWatcher.checkRef(source, this.morSet, game);
    }
}

