/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.OrCost;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.GetEmblemEffect;
import mage.abilities.effects.common.continuous.AddCardTypeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.triggers.BeginningOfCombatTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.game.command.Emblem;
import mage.game.command.emblems.ChandraSparkHunterEmblem;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.VehicleToken;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class ChandraSparkHunter
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.VEHICLE);

    public ChandraSparkHunter(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{3}{R}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.CHANDRA);
        this.setStartingLoyalty(4);
        BeginningOfCombatTriggeredAbility ability = new BeginningOfCombatTriggeredAbility((Effect)new AddCardTypeTargetEffect(Duration.EndOfTurn, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}).setText("choose up to one target Vehicle you control. Until end of turn, it becomes an artifact creature"));
        ability.addEffect((Effect)new GainAbilityTargetEffect((Ability)HasteAbility.getInstance()).setText("and gains haste"));
        ability.addTarget((Target)new TargetPermanent(0, 1, filter));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new LoyaltyAbility((Effect)new DoIfCostPaid((Effect)new DrawCardSourceControllerEffect(1), (Cost)new OrCost("sacrifice an artifact or discard a card", new Cost[]{new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT), new DiscardCardCost()})), 2));
        this.addAbility((Ability)new LoyaltyAbility((Effect)new CreateTokenEffect((Token)new VehicleToken()), 0));
        this.addAbility((Ability)new LoyaltyAbility((Effect)new GetEmblemEffect((Emblem)new ChandraSparkHunterEmblem()), -7));
    }

    private ChandraSparkHunter(ChandraSparkHunter card) {
        super((CardImpl)card);
    }

    public ChandraSparkHunter copy() {
        return new ChandraSparkHunter(this);
    }
}

