/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;

class ChandrasPhoenixTriggeredAbility
extends TriggeredAbilityImpl {
    ChandrasPhoenixTriggeredAbility() {
        super(Zone.GRAVEYARD, (Effect)new ReturnToHandSourceEffect());
    }

    private ChandrasPhoenixTriggeredAbility(ChandrasPhoenixTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ChandrasPhoenixTriggeredAbility copy() {
        return new ChandrasPhoenixTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Object sourceObjectDamage;
        StackObject stackObject;
        Card chandrasPhoenix = game.getCard(this.getSourceId());
        return chandrasPhoenix != null && game.getOpponents(chandrasPhoenix.getOwnerId()).contains(event.getPlayerId()) && (stackObject = game.getStack().getStackObject(event.getSourceId())) != null && (sourceObjectDamage = stackObject instanceof StackAbility ? ((StackAbility)stackObject).getSourceObject(game) : stackObject) != null && sourceObjectDamage.getColor(game).isRed() && (sourceObjectDamage.isPlaneswalker(game) || sourceObjectDamage.isInstant(game) || sourceObjectDamage.isSorcery(game));
    }

    public String getRule() {
        return "Whenever an opponent is dealt damage by a red instant or sorcery spell you control or by a red planeswalker you control, return {this} from your graveyard to your hand.";
    }
}

