/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.PreventionEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChannelHarmEffect
extends PreventionEffectImpl {
    ChannelHarmEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false, false);
        this.staticText = "Prevent all damage that would be dealt to you and permanents you control this turn by sources you don't control. If damage is prevented this way, you may have {this} deal that much damage to target creature";
    }

    private ChannelHarmEffect(ChannelHarmEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public ChannelHarmEffect copy() {
        return new ChannelHarmEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent targetCreature;
        Player sourceController = game.getPlayer(source.getControllerId());
        PreventionEffectData preventionData = this.preventDamageAction(event, source, game);
        if (preventionData.getPreventedDamage() > 0 && (targetCreature = game.getPermanent(source.getFirstTarget())) != null && sourceController != null && sourceController.chooseUse(this.outcome, "Have " + preventionData.getPreventedDamage() + " damage dealt to " + targetCreature.getLogName() + "?", source, game)) {
            targetCreature.damage(preventionData.getPreventedDamage(), source.getSourceId(), source, game, false, true);
        }
        return true;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent targetPermanent;
        if (super.applies(event, source, game) && ((targetPermanent = game.getPermanent(event.getTargetId())) != null && targetPermanent.isControlledBy(source.getControllerId()) || event.getTargetId().equals(source.getControllerId()))) {
            MageObject damageSource = game.getObject(event.getSourceId());
            if (damageSource instanceof Controllable) {
                return !((Controllable)damageSource).isControlledBy(source.getControllerId());
            }
            if (damageSource instanceof Card) {
                return !((Card)damageSource).isOwnedBy(source.getControllerId());
            }
        }
        return false;
    }
}

