/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class ChanneledForceEffect
extends OneShotEffect {
    ChanneledForceEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player draws X cards. {this} deals X damage to up to one target creature or planeswalker.";
    }

    private ChanneledForceEffect(ChanneledForceEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChanneledForceEffect copy() {
        return new ChanneledForceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = GetXValue.instance.calculate(game, source, (Effect)this);
        if (xValue == 0) {
            return false;
        }
        Player player = game.getPlayer(((Target)source.getTargets().get(0)).getFirstTarget());
        if (player != null) {
            player.drawCards(xValue, source, game);
        }
        game.damagePlayerOrPermanent(((Target)source.getTargets().get(1)).getFirstTarget(), xValue, source.getSourceId(), source, game, false, true);
        return true;
    }
}

