/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.common.PreventAllDamageByAllPermanentsEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class ChantOfVituGhaziPreventEffect
extends PreventAllDamageByAllPermanentsEffect {
    ChantOfVituGhaziPreventEffect(FilterCreaturePermanent filter, Duration duration, boolean onlyCombat) {
        super((FilterPermanent)filter, duration, onlyCombat);
        this.staticText = "Prevent all damage that would be dealt by creatures this turn. You gain life equal to the damage prevented this way";
    }

    private ChantOfVituGhaziPreventEffect(ChantOfVituGhaziPreventEffect effect) {
        super((PreventAllDamageByAllPermanentsEffect)effect);
    }

    public ChantOfVituGhaziPreventEffect copy() {
        return new ChantOfVituGhaziPreventEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventionEffectData preventionData = this.preventDamageAction(event, source, game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.gainLife(preventionData.getPreventedDamage(), game, source);
        }
        return false;
    }
}

