/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ChaosHarlequinEffect
extends OneShotEffect {
    ChaosHarlequinEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top card of your library. If that card is a land card, {this} gets -4/-0 until end of turn. Otherwise, {this} gets +2/+0 until end of turn";
    }

    private ChaosHarlequinEffect(ChaosHarlequinEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChaosHarlequinEffect copy() {
        return new ChaosHarlequinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        game.addEffect((ContinuousEffect)new BoostSourceEffect(card.isLand(game) ? -4 : 2, 0, Duration.EndOfTurn), source);
        return true;
    }
}

