/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChaoticGooEffect
extends OneShotEffect {
    ChaoticGooEffect() {
        super(Outcome.Damage);
        this.staticText = "flip a coin. If you win the flip, put a +1/+1 counter on {this}. If you lose the flip, remove a +1/+1 counter from {this}";
    }

    private ChaoticGooEffect(ChaoticGooEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            if (controller.flipCoin(source, game, true)) {
                game.informPlayers("Chaotic Goo: Won flip. Put a +1/+1 counter on Chaotic Goo.");
                new AddCountersSourceEffect(CounterType.P1P1.createInstance(1)).apply(game, source);
                return true;
            }
            game.informPlayers("Chaotic Goo: Lost flip. Remove a +1/+1 counter on Chaotic Goo.");
            new RemoveCounterSourceEffect(CounterType.P1P1.createInstance(1)).apply(game, source);
            return true;
        }
        return false;
    }

    public ChaoticGooEffect copy() {
        return new ChaoticGooEffect(this);
    }
}

