/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactOrEnchantmentCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class CharmedGriffinEffect
extends OneShotEffect {
    CharmedGriffinEffect() {
        super(Outcome.Detriment);
        this.staticText = "each other player may put an artifact or enchantment card onto the battlefield from their hand";
    }

    private CharmedGriffinEffect(CharmedGriffinEffect effect) {
        super((OneShotEffect)effect);
    }

    public CharmedGriffinEffect copy() {
        return new CharmedGriffinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashSet<Card> toBattlefield = new HashSet<Card>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Card card;
                TargetCardInHand target;
                Player player;
                if (playerId.equals(controller.getId()) || (player = game.getPlayer(playerId)) == null || !(target = new TargetCardInHand((FilterCard)new FilterArtifactOrEnchantmentCard())).canChoose(playerId, source, game) || !player.chooseUse(Outcome.Neutral, "Put an artifact or enchantment card from your hand onto the battlefield?", source, game) || !player.choose(Outcome.PutCardInPlay, (Target)target, source, game) || (card = game.getCard(target.getFirstTarget())) == null) continue;
                toBattlefield.add(card);
            }
            return controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game, false, false, true, null);
        }
        return false;
    }
}

