/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.Mana;
import mage.abilities.ActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.MillCardsCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.mana.BasicManaEffect;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.cards.c.CharmedPendantManaEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CharmedPendantAbility
extends ActivatedManaAbilityImpl {
    public CharmedPendantAbility() {
        super(Zone.BATTLEFIELD, (ManaEffect)new CharmedPendantManaEffect(), (Cost)new TapSourceCost());
        this.addCost((Cost)new MillCardsCost());
        this.setUndoPossible(false);
    }

    public CharmedPendantAbility(Zone zone, Mana mana, Cost cost) {
        super(zone, (ManaEffect)new BasicManaEffect(mana), cost);
    }

    private CharmedPendantAbility(CharmedPendantAbility ability) {
        super((ActivatedManaAbilityImpl)ability);
    }

    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Player player = game.getPlayer(playerId);
        if (player != null && !player.isInPayManaMode()) {
            return super.canActivate(playerId, game);
        }
        return ActivatedAbility.ActivationStatus.getFalse();
    }

    public CharmedPendantAbility copy() {
        return new CharmedPendantAbility(this);
    }

    public String getRule() {
        return super.getRule() + " Activate only as an instant.";
    }
}

