/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class CharnelSerenadeEffect
extends OneShotEffect {
    CharnelSerenadeEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then return a creature card from your graveyard to the battlefield with a finality counter on it";
    }

    private CharnelSerenadeEffect(CharnelSerenadeEffect effect) {
        super((OneShotEffect)effect);
    }

    public CharnelSerenadeEffect copy() {
        return new CharnelSerenadeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) < 1) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        game.setEnterWithCounters(card.getId(), new Counters(new Counter[0]).addCounter(CounterType.FINALITY.createInstance()));
        return player.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

