/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ChastiseEffect
extends OneShotEffect {
    ChastiseEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to its power";
    }

    private ChastiseEffect(ChastiseEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChastiseEffect copy() {
        return new ChastiseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            int power = permanent.getPower().getValue();
            Player player = game.getPlayer(source.getControllerId());
            if (player != null) {
                player.gainLife(power, game, source);
            }
            return true;
        }
        return false;
    }
}

