/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class ChecksAndBalancesEffect
extends OneShotEffect {
    ChecksAndBalancesEffect() {
        super(Outcome.Detriment);
        this.staticText = "each of that player's opponents may discard a card. If they do, counter that spell";
    }

    private ChecksAndBalancesEffect(ChecksAndBalancesEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChecksAndBalancesEffect copy() {
        return new ChecksAndBalancesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            Player player;
            for (UUID uuid : game.getOpponents(spell.getControllerId())) {
                player = game.getPlayer(uuid);
                if (player == null || !player.getHand().isEmpty()) continue;
                game.informPlayers(player.getLogName() + " doesn't have a card in hand to discard to counter " + spell.getLogName() + ", effect aborted.");
                return true;
            }
            for (UUID uuid : game.getOpponents(spell.getControllerId())) {
                player = game.getPlayer(uuid);
                if (player == null) continue;
                if (!player.chooseUse(this.outcome, "Discard a card to counter " + spell.getLogName() + '?', source, game)) {
                    game.informPlayers(player.getLogName() + " refuses to discard a card to counter " + spell.getLogName());
                    return true;
                }
                game.informPlayers(player.getLogName() + " agrees to discard a card to counter " + spell.getLogName());
            }
            for (UUID uuid : game.getOpponents(spell.getControllerId())) {
                TargetCardInHand target;
                player = game.getPlayer(uuid);
                if (player == null || player.getHand().isEmpty() || !player.choose(Outcome.Discard, (Target)(target = new TargetCardInHand()), source, game)) continue;
                Card card = game.getCard(target.getFirstTarget());
                player.discard(card, false, source, game);
            }
            game.getStack().counter(spell.getId(), source, game);
            return true;
        }
        return false;
    }
}

