/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersAllEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.DieRolledEvent;
import mage.game.events.GameEvent;

class ChickenALaKingTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("each Bird");

    public ChickenALaKingTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersAllEffect(CounterType.P1P1.createInstance(), (FilterPermanent)filter));
    }

    private ChickenALaKingTriggeredAbility(ChickenALaKingTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ChickenALaKingTriggeredAbility copy() {
        return new ChickenALaKingTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DIE_ROLLED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DieRolledEvent drEvent = (DieRolledEvent)event;
        return this.isControlledBy(drEvent.getPlayerId()) && drEvent.getSides() == 6 && drEvent.getResult() == 6;
    }

    public String getRule() {
        return "Whenever a 6 is rolled on a six-sided die, put a +1/+1 counter on each Bird.";
    }

    static {
        filter.add((Predicate)SubType.BIRD.getPredicate());
    }
}

