/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.GiantBirdToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class ChickenEggEffect
extends OneShotEffect {
    ChickenEggEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a six-sided die. If you roll a 6, sacrifice {this} and create a 4/4 red Giant Bird creature token";
    }

    private ChickenEggEffect(ChickenEggEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int result;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (result = controller.rollDice(this.outcome, source, game, 6)) == 6) {
            new SacrificeSourceEffect().apply(game, source);
            return new CreateTokenEffect((Token)new GiantBirdToken(), 1).apply(game, source);
        }
        return false;
    }

    public ChickenEggEffect copy() {
        return new ChickenEggEffect(this);
    }
}

