/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.AffinityForArtifactsAbility;
import mage.cards.Card;
import mage.cards.c.ChissGoriaForgeTyrantWatcher;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class ChissGoriaForgeTyrantAffinityEffect
extends ContinuousEffectImpl {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    public ChissGoriaForgeTyrantAffinityEffect(Set<MageObjectReference> morSet) {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.Benefit);
        this.morSet.addAll(morSet);
    }

    protected ChissGoriaForgeTyrantAffinityEffect(ChissGoriaForgeTyrantAffinityEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.morSet.addAll(effect.morSet);
    }

    public ChissGoriaForgeTyrantAffinityEffect copy() {
        return new ChissGoriaForgeTyrantAffinityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!ChissGoriaForgeTyrantWatcher.checkRef(source, this.morSet, game)) {
            this.discard();
            return false;
        }
        for (Card card : game.getExile().getCardsInRange(game, source.getControllerId())) {
            if (!this.morSet.contains(new MageObjectReference((MageObject)card, game)) || !card.isArtifact(game)) continue;
            game.getState().addOtherAbility(card, (Ability)new AffinityForArtifactsAbility());
        }
        for (StackObject stackObject : game.getStack()) {
            Card card;
            if (!(stackObject instanceof Spell) || !stackObject.isControlledBy(source.getControllerId()) || (card = game.getCard(stackObject.getSourceId())) == null || !this.morSet.contains(new MageObjectReference((MageObject)card, game, -1))) continue;
            game.getState().addOtherAbility(card, (Ability)new AffinityForArtifactsAbility());
        }
        return true;
    }
}

