/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.cards.c.ChissGoriaForgeTyrantAffinityEffect;
import mage.cards.c.ChissGoriaForgeTyrantCanPlayEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ChissGoriaForgeTyrantEffect
extends OneShotEffect {
    ChissGoriaForgeTyrantEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top five cards of your library. You may cast an artifact spell from among them this turn. If you do, it has affinity for artifacts.";
    }

    private ChissGoriaForgeTyrantEffect(ChissGoriaForgeTyrantEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChissGoriaForgeTyrantEffect copy() {
        return new ChissGoriaForgeTyrantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 5));
        if (cards.isEmpty()) {
            return true;
        }
        player.moveCardsToExile(cards.getCards(game), source, game, false, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        cards.retainZone(Zone.EXILED, game);
        CardsImpl castableCards = new CardsImpl(cards.getCards((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game));
        HashSet<MageObjectReference> morSet = new HashSet<MageObjectReference>();
        castableCards.stream().map(uuid -> new MageObjectReference(uuid, game)).forEach(morSet::add);
        game.addEffect((ContinuousEffect)new ChissGoriaForgeTyrantCanPlayEffect(morSet), source);
        game.addEffect((ContinuousEffect)new ChissGoriaForgeTyrantAffinityEffect(morSet), source);
        return true;
    }
}

