/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CinderCloudEffect
extends OneShotEffect {
    CinderCloudEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy target creature. If a white creature dies this way, {this} deals damage to that creature's controller equal to the creature's power";
    }

    private CinderCloudEffect(CinderCloudEffect effect) {
        super((OneShotEffect)effect);
    }

    public CinderCloudEffect copy() {
        return new CinderCloudEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && permanent.destroy(source, game, false) && permanent.getColor(game).equals((Object)ObjectColor.WHITE)) {
            game.processAction();
            if (permanent.getZoneChangeCounter(game) + 1 == game.getState().getZoneChangeCounter(permanent.getId()) && game.getState().getZone(permanent.getId()) != Zone.GRAVEYARD) {
                return true;
            }
            Player permanentController = game.getPlayer(permanent.getControllerId());
            if (permanentController != null) {
                int damage = permanent.getPower().getValue();
                permanentController.damage(damage, source.getSourceId(), source, game);
            }
        }
        return false;
    }
}

