/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetOpponentsCreaturePermanent;

class CinderheartGiantEffect
extends OneShotEffect {
    CinderheartGiantEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals 7 damage to a creature an opponent controls chosen at random";
    }

    private CinderheartGiantEffect(CinderheartGiantEffect effect) {
        super((OneShotEffect)effect);
    }

    public CinderheartGiantEffect copy() {
        return new CinderheartGiantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_OPPONENTS_PERMANENT_CREATURE, source.getControllerId(), source, game) < 1) {
            return false;
        }
        TargetOpponentsCreaturePermanent target = new TargetOpponentsCreaturePermanent();
        target.withNotTarget(true);
        target.setRandom(true);
        target.chooseTarget(this.outcome, player.getId(), source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && permanent.damage(7, source.getSourceId(), source, game) > 0;
    }
}

